package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.dialog.VariableLimitationsDialog;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class VariableLimitations extends Modifier {

	private static String xmlID = "VARIABLELIMITATIONS";

	public VariableLimitations(Element root) {
		super(root, VariableLimitations.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (adderString.length() > 0) {
				adderString += ", ";
			}
			adderString += ad.getAlias();
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		double required = getLevels() * getLevelCost() + getBaseCost()
				/ (getLevelCost() / getLevelValue());
		required = Rounder.roundDown(required * 4) / 4d;
		ret += "requires " + getFraction(required) + " worth of Limitations; ";
		if (adderString.trim().length() > 0) {
			ret += adderString + "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		return ret;
	}

	@Override
	public ModifierDialog getDialog(GenericObject parent, boolean isNew) {
		return new VariableLimitationsDialog(this, isNew, parent);
	}

	@Override
	public int getLevels() {
		int ret = levels;
		return ret;
	}

	@Override
	public double getTotalValue() {
		double val = getBaseCost();
		for (Adder ad : getAssignedAdders()) {
			val += ad.getDoubleTotal();
		}
		if (getLevelCost() != 0) {
			int mult = 1;
			if ((getLevelValue() < 0) && (getLevelCost() < 0)) {
				mult = -1;
			}
			double temp = getLevels() * getLevelValue() * getLevelCost();
			temp = Rounder.roundDown(temp * 4) / 4d;
			temp = temp * mult;
			val += temp;
		}
		double advantageTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getTotalValue() > 0) {
				advantageTotal += mod.getTotalValue();
			}
		}
		double active = val * (1 + advantageTotal);
		double limitationTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getTotalValue() < 0) {
				limitationTotal += Math.abs(mod.getTotalValue());
			}
		}
		val = active / (1 + limitationTotal);
		// the following effectively "rounds" the value to the closest 1/4
		val = val * 4d;
		int mult = 1;
		if (val < 0) {
			mult = -1;
		}
		val = val * mult;
		val = Rounder.roundHalfUp(val);
		val = val * mult;
		val = val / 4d;

		if ((val < getMinimumCost()) && isMinSet()) {
			return getMinimumCost();
		} else if ((val > getMaxCost()) && isMaxSet()) {
			return getMaxCost();
		} else {
			return val;
		}
	}

	@Override
	public boolean isLimitation() {
		return true;
	}

	public boolean isValueModifiable() {
		return false;
	}

	@Override
	public boolean noDisplayDialog() {
		return false;
	}

	@Override
	public void restoreFromSave(Element root) {
		double origBase = baseCost;
		super.restoreFromSave(root);
		if ((baseCost != origBase) && (getLevelValue() != 0)
				&& (getLevelCost() != 0)) {
			double val = baseCost - origBase;
			levels = (int) Rounder.roundDown(val * getLevelValue()
					/ getLevelCost() / getLevelCost());
			baseCost = origBase;
		}
	}
}